//
// Illustrator CS Import
// Martin Wengenmayer modified 20050202 Adrian Ward
// 
// Illustrator 8 Import for ver.5,6,7,8 AI file
// ver. 0.5.1
// Modified 20050614 Hiroto Tsubaki
// Modified 20050615 Hiroto Tsubaki

var scale = 0.01;

function main(doc){
	
    var path = OS.runOpenPanel("ai");
    if (path == null) {
		print("Cancel");
		return;
	}
    
    var file = new File(path);
    file.open(READ_MODE);
    if (file.isOpen() == false) {
		print("file not open");
		return;
	}
    
    var splineobj;
    var spline;
	
    var line;
    var to	        = new Vector(0,0,0,0);
    var cont1       = new Vector(0,0,0,0);
    var cont2       = new Vector(0,0,0,0);
    var complete    = 0;
	var nullcount   = 0;
	var hitcount    = 0;
	var linecount = 0;
		
	line = file.readln();
	
	while (line != '%%EOF' && line != null) {
	
		while (line != '%AI5_BeginLayer' && line != '%%EOF') {
			line = file.readln();
			linecount++;
		}
		
		if (line == '%AI5_BeginLayer') {
			if (splineobj) splineobj.update();
			splineobj = doc.addObject(SPLINE);
			spline = splineobj.core();
		} else {
			break;
		}
		
		//print("start:"+line);
		
		while (line != '%AI5_EndLayer--' && line != '%%EOF') {
			line = file.readln();
			linecount++;
			var data = line.split(/ /);
			if (data.length == 2 && data[1] == 'Ln') {
				var str_length = data[0].length;
				var name = data[0].substr(1,str_length - 2);
				if (!name) name = 'Undefined';
				
				splineobj.setParameter("name",name);
				
				//print("layer name:"+name);
			} else if (data.length == 3 && data[2].localeCompare("m") == 0) {
			    to.x    = scale * parseFloat(data[0]);
			    to.y    = -scale * parseFloat(data[1]);
			    spline.move(to);
				hitcount++;
				//print("line move");
			} else if (data.length == 3 && (data[2].localeCompare("l") == 0 || data[2].localeCompare("L") == 0)) { 
			    to.x    = scale * parseFloat(data[0]);
			    to.y    = -scale * parseFloat(data[1]);
			    spline.line(to);
				hitcount++;
			} else if (data.length == 5 && (data[4].localeCompare("v") == 0 || data[4].localeCompare("V") == 0)) { 
			    cont2.x = scale * parseFloat(data[0]);
			    cont2.y = -scale * parseFloat(data[1]);
			    to.x    = scale * parseFloat(data[2]);
			    to.y    = -scale * parseFloat(data[3]);
			    spline.curve(spline.currentPoint(),cont2,to);
				hitcount++;
			} else if (data.length == 5 && (data[4].localeCompare("y") == 0 || data[4].localeCompare("Y") == 0)) { 
			    cont1.x = scale * parseFloat(data[0]);
			    cont1.y = -scale * parseFloat(data[1]);
			    cont2.x = to.x = scale * parseFloat(data[2]);
			    cont2.y = to.y = -scale * parseFloat(data[3]);
			    spline.curve(cont1,cont2,to);
				hitcount++;
			} else if (data.length == 7 && (data[6].localeCompare("c") == 0 || data[6].localeCompare("C") == 0)) { 
			    cont1.x = scale * parseFloat(data[0]);
			    cont1.y = -scale * parseFloat(data[1]);
			    cont2.x = scale * parseFloat(data[2]);
			    cont2.y = -scale * parseFloat(data[3]);
			    to.x    = scale * parseFloat(data[4]);
			    to.y    = -scale * parseFloat(data[5]);
			    spline.curve(cont1,cont2,to);
				hitcount++;
			} else if (data.length == 1) {
			    if (data[0].localeCompare("f") == 0 || data[0].localeCompare("s") == 0 || data[0].localeCompare("b") == 0) { 
						//spline.close();
				}
			}
		}
	}
	
	if (splineobj) splineobj.update();

    file.close();

	if (hitcount == 0) {
		OS.messageBox("Adobe Illustrator Import","No path data could be imported. Please ensure the .ai file is saved without any compression.");
	}
    
}



